
--[[ 
    TABAS_BathTimeKeyPressedEvents.lua
    This file handles the key events for changing the action during bath time. 
It listens for specific key presses and updates the character's bath time action accordingly.
]]
--[[default key number = {
    "W" = 17,
    "A" = 30,
    "S" = 31,
    "D" = 32,
    "Shift" = 42
    "Shift2" = 54
]]
local function bathTimeKeyPressedEvents(_keyPressed, character)
    if not character:getModData().isBathing then return end

    local key = _keyPressed
    if key == 17 or key == 30 or key == 31 or key == 32 then
        -- print("pressed key W:")
        character:setVariable("BathTimeStopped", true)
    end
end

local function bathTimeKeyKeepPressedEvents(_keyPressed, character)
    if not character:getModData().isBathing then return end

    local key = _keyPressed
    if key == 42 or key == 54 then
        character:setVariable("BathOutFast", true)
    end
end

local function bathTimeKeyReleaseEvents(_keyPressed, character)
    if not character:getModData().isBathing then return end
    if character:getVariableBoolean("BathTimeStopped") then return end

    local key = _keyPressed
    if key == 42 or key == 54 then
        character:setVariable("BathOutFast", false)
        print("release shift key")
    end
end

local function onKeyStartPressed(_keyPressed)
    for i=0, getNumActivePlayers()-1 do
        local character = getSpecificPlayer(i)
        if character and character:getModData() then
            bathTimeKeyPressedEvents(_keyPressed, character)
        end
    end
end

local function onKeyKeepPressed(_keyPressed)
    for i=0, getNumActivePlayers()-1 do
        local character = getSpecificPlayer(i)
        if character and character:getModData() then
            bathTimeKeyKeepPressedEvents(_keyPressed, character)
        end
    end
end
local function onKeyPressed(_keyPressed)
    for i=0, getNumActivePlayers()-1 do
        local character = getSpecificPlayer(i)
        if character and character:getModData() then
            bathTimeKeyReleaseEvents(_keyPressed, character)
        end
    end
end

Events.OnKeyStartPressed.Add(onKeyStartPressed)
Events.OnKeyKeepPressed.Add(onKeyKeepPressed)
Events.OnKeyPressed.Add(onKeyPressed)